/**
 * 
 */
package gov.va.med.mhv.integration.phr.service;

import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;

import java.util.Date;
import java.util.List;

/**
 * @author DNS
 *
 */
public class ComplexProcessingPolicy extends AbstractProcessingPolicy {
	
	private enum ExpressionType { 
		
		AND(false), 
		OR(true);
		
		private boolean initValue;
		
		ExpressionType(boolean initValue){
			this.initValue = initValue;
		}
		
	};
	
	private ExpressionType expressionType;
	
	private List<ProcessingPolicy> policies;

	@Override
	public void setEnabled(boolean value) {
		this.enabled = value;
	}
	
	public void setExpressionType(String expressionType) {
		this.expressionType = ExpressionType.valueOf(expressionType);
	}

	public void setPolicies(List<ProcessingPolicy> policies) {
		this.policies = policies;
	}

	@Override
	public boolean isAllowed(FacilityExtractStatus es) {
		
		boolean retVal = this.expressionType.initValue;
		
		for(ProcessingPolicy pp : policies)
		{
			switch(this.expressionType)
			{
			case AND:
				retVal &= pp.isAllowed(es);
			case OR:
			default:
				retVal |= pp.isAllowed(es);
			}
		}
		return retVal;
	}
	
	@Override
	public boolean isAllowed(Date lastProcessed) {
		throw new UnsupportedOperationException("Complex Processing Policies don't allow policy checks based on date last processed alone.");
	}
	
	@Override
	public Date getProjectedDate(Date lastProcessed) {
		Date nextAvailableProcessingDate = null;
		
		for(ProcessingPolicy pp : policies)
		{
			try {
				nextAvailableProcessingDate = pp.getProjectedDate(lastProcessed);
				if(nextAvailableProcessingDate != null)
				{
					break;
				}
			} catch (UnsupportedOperationException uoe)
			{
				// eat this exception. it's expected for some processing policies.
			}
		}
		
		return nextAvailableProcessingDate;
	}
	
}
